﻿namespace Microsoft.Samples.PlanMyNight.Web.Helpers.Tests
{
    using Microsoft.Samples.PlanMyNight.Web;
    using Microsoft.VisualStudio.TestTools.UnitTesting;

    [TestClass]
    public class TimeHelperFixture
    {
        [TestMethod]
        public void ZeroReturnsSlash()
        {
            Assert.AreEqual("-", TimeHelper.GetFriendlyTime(0));
        }

        [TestMethod]
        public void LessThan60MinutesReturnsValueInMinutes()
        {
            Assert.AreEqual("10m", TimeHelper.GetFriendlyTime(10));
        }

        [TestMethod]
        public void MoreThan60MinutesReturnsValueInHoursAndMinutes()
        {
            Assert.AreEqual("2h 3m", TimeHelper.GetFriendlyTime(123));
        }
    }
}
